# RobloxBackend SDK Documentation

RobloxBackend provides three specialized SDKs for Roblox game development: **Anti-Exploit**, **Analytics**, and **Trading**.

## 🚀 Getting Started

To use any SDK, require the module and initialize it with your API Key:

```lua
local SDK = require(game.ReplicatedStorage.SDKName)
SDK.init("YOUR_API_KEY") -- Default base URL is https://dogan.works
```

---

## 🛡️ Anti-Exploit SDK (`AntiExploitSDK.lua`)

Used for detecting, reporting, and managing exploiters.

### Methods

| Method | Description |
| :--- | :--- |
| `init(apiKey, baseUrl)` | SDK'yı başlatır. `baseUrl` opsiyoneldir. |
| `report(userId, exploitType, metadata)` | Şüpheli bir aktiviteyi raporlar. `exploitType`: `SPEED_HACK`, `TELEPORT`, vb. |
| `checkBan(userId)` | Oyuncunun banlı olup olmadığını kontrol eder. `bool, reason, expiresAt` döner. |
| `ban(userId, duration, reason, type)` | Oyuncuyu banlar. `duration` saniye cinsindendir (nil = kalıcı). |
| `unban(userId)` | Oyuncunun banını kaldırır. |
| `getStats()` | Exploit istatistiklerini döndürür (toplam rapor, ban, tehdit dağılımı). |
| `getReports(page, limit, filters)` | Exploit raporlarını listeler. `filters`: `{userId, type, startDate, endDate}` |
| `detectSpeedHack(player, maxSpeed)` | Oyuncunun hız hilesi yapıp yapmadığını otomatik kontrol eder ve raporlar. |
| `detectTeleport(player, lastPos, maxDist)` | Oyuncunun ışınlanma hilesini kontrol eder ve raporlar. |

---

## 📊 Analytics SDK (`AnalyticsSDK.lua`)

Used for tracking player behavior and game performance.

### Methods

| Method | Description |
| :--- | :--- |
| `init(apiKey, baseUrl)` | SDK'yı ve toplu işlem (batch) motorunu başlatır. |
| `track(userId, event, props)` | Bir olayı kuyruğa ekler (otomatik olarak toplu gönderilir). |
| `trackImmediate(userId, event, props)` | Kuyruğa girmeden anında sunucuya gönderir. |
| `batchTrack(events)` | Birden fazla olayı aynı anda kuyruğa ekler. |
| `getPlayerStats(userId)` | Oyuncunun istatistiklerini (harcama, seviye vb.) getirir. |

### Helper Methods
- `sessionStart(userId)` - Oturum başlangıcını kaydeder
- `firstSession(userId)` - İlk oturumu kaydeder (retention hesaplaması için)
- `sessionEnd(userId, duration)` - Oturum bitişini kaydeder
- `purchase(userId, itemId, price, currency)` - Satın alma kaydeder
- `levelComplete(userId, level, score)` - Seviye tamamlama kaydeder
- `tutorialComplete(userId)` - Tutorial tamamlama kaydeder
- `customEvent(userId, eventName, properties)` - Özel event kaydeder

---

## 🔄 Trading SDK (`TradingSDK.lua`)

Used for managing secure player-to-player trades.

### Methods

| Method | Description |
| :--- | :--- |
| `init(apiKey, baseUrl)` | SDK'yı başlatır. |
| `createTrade(p1Id, p2Id)` | Yeni bir takas oturumu başlatır. `tradeId` döner. |
| `addItems(tradeId, pId, items)` | Takasa eşya ekler. |
| `setReady(tradeId, pId, ready)` | Oyuncunun hazır durumunu günceller. |
| `completeTrade(tradeId)` | Takası tamamlar ve eşya transferlerini onaylar. |
| `cancelTrade(tradeId, pId)` | Takası iptal eder. |
| `verifyOwnership(pId, items)` | Oyuncunun envanterindeki eşyaları doğrular. |
| `getHistory(pId, page, limit)` | Oyuncunun geçmiş takaslarını listeler. |
| `getStats()` | Takas istatistiklerini döndürür (toplam, 24s, 7g, benzersiz trader). |

---
